<Project>
    <Setup headers="type,value">
        <Component><Tip charge="" type="molecule" free="">co.txyz<Position><x unit="angstrom">0</x>
                    <y unit="angstrom">0</y>
                    <z unit="angstrom" min="0">15</z>
                </Position>
                <Rotation><alpha min="-180" max="180">0</alpha>
                    <beta min="-180" max="180">0</beta>
                    <gamma min="-180" max="180">0</gamma>
                </Rotation>
                <Size><w unit="angstrom" ctrl="label">0</w>
                    <d unit="angstrom" ctrl="label">0</d>
                    <h unit="angstrom" ctrl="label">1.128</h>
                </Size>
                <Property><young unit="GPa">76.5</young>
                    <poisson>0.22</poisson>
                    <hamaker unit="zJ">50</hamaker>
                </Property>
                <ScanArea><w unit="angstrom" max="1000">0</w>
                    <d unit="angstrom" max="1000">0</d>
                    <h unit="angstrom" max="1000">6</h>
                </ScanArea>
                <DistanceFromSamples unit="angstrom">6.79528804460521</DistanceFromSamples>
            </Tip>
            <Sample charge="0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0" type="molecule" free="0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1">octane.txyz<Position><x unit="angstrom">0</x>
                    <y unit="angstrom">0</y>
                    <z unit="angstrom" min="0">0</z>
                </Position>
                <Rotation><alpha min="-180" max="180">-94</alpha>
                    <beta min="-180" max="180">-40</beta>
                    <gamma min="-180" max="180">-78</gamma>
                </Rotation>
                <Size><w unit="angstrom" ctrl="label">5.83664939798442</w>
                    <d unit="angstrom" ctrl="label">4.77973021970302</d>
                    <h unit="angstrom" ctrl="label">8.20471195539479</h>
                </Size>
                <Property><young unit="GPa">76.5</young>
                    <poisson>0.22</poisson>
                    <hamaker unit="zJ">50</hamaker>
                </Property>
            </Sample>
        </Component>
    </Setup>
    <FEM headers="name,value,unit,descriptions">
        <Tip><Property><density unit="kg/m3" min="0.0" max="100000.0">2329.0</density>
                <spring_constant unit="N/m" min="0.0">0.05</spring_constant>
            </Property>
        </Tip>
        <Sample><Property><surface_tension unit="N/m" min="0.0">0.108</surface_tension>
            </Property>
        </Sample>
        <JKR_Position><ix stepsize="1" type="int" min="1" max="1000">1</ix>
            <iy stepsize="1" type="int" min="1" max="1000">1</iy>
        </JKR_Position>
        <simulation><resolution unit="angstrom" stepsize="0.1" min="0.1" decimal="2" max="10.0">2</resolution>
            <amplitude unit="angstrom" stepsize="1" min="0.0" decimal="3" max="999">0.0</amplitude>
            <frequency unit="GHz" unitgrp="kHz,MHz,GHz" min="0.0">0.0</frequency>
            <cycles_per_resolution type="int" min="0">0</cycles_per_resolution>
        </simulation>
        <OpenMP_threads type="int" min="1">1</OpenMP_threads>
        <simulation_mode options="femafm_Van_der_Waals_force,femafm_frequency_shift,femafm_JKR">femafm_Van_der_Waals_force</simulation_mode>
        <Output><Directory ctrl="label">.\<Movie displaytype="movie" ctrl="label">movie.mvc</Movie>
                <simulated_image displaytype="2D" ctrl="label">femafm_simulation_image.csv</simulated_image>
                <simulated_frequency_shift displaytype="2D" ctrl="label">femafm_simulation_frequency_shift.csv</simulated_frequency_shift>
                <simulated_tip_delta_force ctrl="label">femafm_simulation_tip_delta_force.csv</simulated_tip_delta_force>
            </Directory>
        </Output>
    </FEM>
    <MD headers="property,value,unit,descriptions">
        <Tip_Control><scanmode options="relaxation,ForceCurve,3D_Force,ConstZ,NC_ConstZ,ConstF,NC_FSCurve,NC_ConstFS">ForceCurve</scanmode>
            <delta_x unit="Ang" stepsize="0.01" min="0.01" decimal="5" max="1000.0">1</delta_x>
            <delta_y unit="Ang" stepsize="0.01" min="0.01" decimal="5" max="1000.0">1</delta_y>
            <delta_z unit="Ang" stepsize="0.01" min="0.0" decimal="5" max="1000.0">0.5</delta_z>
            <xy_scanning options="one_Direction,zigzag">zigzag</xy_scanning>
            <constForce unit="nN" stepsize="0.01" min="-1.0" max="1.0">0.05</constForce>
            <NC_Mode_Setting><ThetaStepNumber stepsize="1" type="int" min="0.5" max="20">2</ThetaStepNumber>
                <TipZamplitude unit="Ang" stepsize="1.0" min="1.0" decimal="1" max="200">5</TipZamplitude>
                <SpringConst unit="N/m" stepsize="10.0" min="1.0" decimal="1" max="1000">300</SpringConst>
            </NC_Mode_Setting>
        </Tip_Control>
        <MD_Setting><TimeStep unit="fs" stepsize="0.1" min="0.001" max="1.5">1</TimeStep>
            <StepNumber stepsize="100" type="int" min="1" max="1000000">10000</StepNumber>
            <Temperature unit="K" stepsize="1" min="0" max="500">300</Temperature>
        </MD_Setting>
        <ForceField_Parameter><Safety_mode options="stopCalc,setZeroParam,fixMolecule">fixMolecule</Safety_mode>
        </ForceField_Parameter>
        <Input><Initial_Velocity suffix="vel" ctrl="pathdialog"></Initial_Velocity>
        </Input>
        <Output><Directory ctrl="label">.\<Fx suffix="csv" displaytype="2D" ctrl="label">MD_Fx.csv</Fx>
                <Fy suffix="csv" displaytype="2D" ctrl="label">MD_Fy.csv</Fy>
                <Fz suffix="csv" displaytype="2D" ctrl="label">MD_Fz.csv</Fz>
                <FrequencyShift_2D suffix="csv" displaytype="2D" ctrl="label">MD_FS2D.csv</FrequencyShift_2D>
                <Energy suffix="csv" displaytype="1D" ctrl="label">MD_Energy.csv<energy_freq stepsize="10" type="int" min="1" max="10000">500</energy_freq>
                </Energy>
                <Movie suffix="mvc" displaytype="movie" ctrl="label">MD_out.mvc<movie_freq stepsize="10" type="int" min="1" max="10000">50</movie_freq>
                </Movie>
            </Directory>
        </Output>
    </MD>
    <CG headers="property,value,unit,descriptions">
        <AFMmode options="CG,CG_RISM">CG</AFMmode>
        <Tip_Control><scanmode options="ConstZ,ConstForce,ncAFMConstZ,ForceCurve,MinForceHeight">ConstZ</scanmode>
            <delta_xy unit="Ang" stepsize="0.01" min="0.0" decimal="5" max="1000.0">0.2</delta_xy>
            <delta_z unit="Ang" stepsize="0.01" min="0.0" decimal="5" max="1000.0">0.2</delta_z>
            <NC_Mode_Setting><ThetaStepNumber type="int" min="1" max="1000">10</ThetaStepNumber>
                <TipZamplitude unit="Ang" stepsize="1.0" min="0.0" decimal="5" max="1000.0">0.5</TipZamplitude>
                <SpringConst unit="N/m" stepsize="0.1" min="0.0" decimal="5" max="1000.0">200</SpringConst>
                <ResoFreq unit="kHz" stepsize="1.0" min="0.0" decimal="5" max="1000.0">25.0</ResoFreq>
                <FreqShift unit="Hz" stepsize="0.1" min="-100.0" decimal="5" max="100.0">5</FreqShift>
            </NC_Mode_Setting>
            <ForceConst unit="nN" stepsize="0.01" min="-100.0" decimal="5" max="100.0">0.5</ForceConst>
            <resetStruct_atZmax options="Yes,No">No</resetStruct_atZmax>
            <OneWayForceCurve options="Yes,No">No</OneWayForceCurve>
        </Tip_Control>
        <ForceField><nonElectroStatic options="6-12_LJ_noCutoff,6-12_LJ_withCutoff,6-exp_LJ_noCutoff,6-exp_LJ_withCutoff">6-exp_LJ_noCutoff</nonElectroStatic>
            <ElectroStatic options="Yes,No">Yes</ElectroStatic>
        </ForceField>
        <RISM><TypeOfFourierTransform options="log,linear" descriptions="linear/log">log</TypeOfFourierTransform>
            <Temperature unit="K" stepsize="1.0" min="0.0" decimal="5" max="1000.0">298.0</Temperature>
            <NumberOfRadiusBin type="int" min="64" max="4096" descriptions="Power of 2 is recommended">512</NumberOfRadiusBin>
            <LogRadiusMin unit="ln(rmin/Ang)" stepsize="0.1" min="-20" decimal="5" max="0" descriptions="log Fourier Trans. only">-4.37</LogRadiusMin>
            <DeltaLogRadius unit="delta ln(r/Ang)" stepsize="0.001" min="0.0" decimal="5" max="1000.0" descriptions="log Fourier Trans. only">0.021</DeltaLogRadius>
            <VolumeRadius unit="Ang" stepsize="0.1" min="0.0" decimal="5" max="1000.0" descriptions="linear Fourier Trans. only">10</VolumeRadius>
            <Solvent><Molecule ctrl="label" descriptions="water only">water</Molecule>
                <NumberDensity unit="Ang^(-3)" stepsize="0.01" min="0.0" decimal="5" max="1000.0">0.03334</NumberDensity>
            </Solvent>
            <Solvent_Solvent><InitialBroadening unit="Ang" stepsize="0.01" min="0.0" decimal="5" max="10.0">1.5</InitialBroadening>
                <Tolerance stepsize="0.00001" min="0.0" decimal="5" max="1.0">0.0001</Tolerance>
                <RISMStepMax type="int" min="0" max="100000">1000</RISMStepMax>
            </Solvent_Solvent>
            <Solute_Solvent><InitialBroadening unit="Ang" stepsize="0.01" min="0.0" decimal="5" max="10.0">1.5</InitialBroadening>
                <Tolerance stepsize="0.00001" min="0.0" decimal="5" max="1.0">0.0001</Tolerance>
                <RISMStepMax type="int" min="0" max="100000">1000</RISMStepMax>
            </Solute_Solvent>
        </RISM>
        <Output><Directory ctrl="label">./<Fx displaytype="2D" ctrl="label">cgafm_fx.csv</Fx>
                <Fy displaytype="2D" ctrl="label">cgafm_fy.csv</Fy>
                <Fz displaytype="2D" ctrl="label">cgafm_fz.csv</Fz>
                <PotentialEnergy displaytype="2D" ctrl="label">cgafm_pot_ene.csv</PotentialEnergy>
                <FrequencyShift_2D displaytype="2D" ctrl="label">cgafm_frq.csv</FrequencyShift_2D>
                <EnergyDissipation_2D displaytype="2D" ctrl="label">cgafm_eng.csv</EnergyDissipation_2D>
                <TipPositionZ displaytype="2D" ctrl="label">cgafm_tipz.csv</TipPositionZ>
                <Movie displaytype="movie" ctrl="label">cgafm_mov.mvc</Movie>
            </Directory>
        </Output>
    </CG>
    <DFTB headers="property,value,unit,descriptions">
        <mode options="DFTB_AFM,DFTB_STM,DFTB_STS,DFTB_KPFM">DFTB_AFM</mode>
        <title type="text" descriptions="not used in calculation">brief description of this calculation</title>
        <two_body_parameter_folder options="h-c-si,h-n-si,h-o-si,h-si-p,h-si-w,h-o-w,h-si-pt,h-c-pt,h-si-au,h-c-au,h-si-ti-o,w-ti-o,au-ti-o,pt-ti-o,h-si-al-o,h-si-ru-o,w-ru-o,au-ru-o,pt-ru-o">h-c-si</two_body_parameter_folder>
        <tip><amplitude unit="Ang" min="0.0" decimal="5" max="10000.0">160.00000</amplitude>
            <k_cantilever unit="N/m" min="0.0" decimal="5" max="10000.0">41.00000</k_cantilever>
            <resonant_freq unit="kHz" min="0.0" decimal="5" max="10000.0">172.00000</resonant_freq>
            <Ndiv><X type="int" min="0" descriptions="0: ignore scan width">30</X>
                <Y type="int" min="0" descriptions="0: ignore scan depth">30</Y>
                <Z type="int" min="0" descriptions="0: ignore scan height">15</Z>
            </Ndiv>
        </tip>
        <CG_param><MaxIter type="int" min="0" descriptions="0: No structural optimization">0</MaxIter>
            <TolForce suffix="nN" unit="nN" min="0.0" decimal="5" max="10000.0">1.0</TolForce>
            <TolEnergy unit="eV" stepsize="0.001" min="0.0" decimal="5" max="1.0">0.001</TolEnergy>
            <displacement unit="Ang" min="0.0" decimal="5" max="1.0">0.10000</displacement>
            <trial_point_number type="int" min="0">10</trial_point_number>
        </CG_param>
        <Broyden_param><MaxIter type="int" min="0" max="1000">150</MaxIter>
            <TolEnergy unit="10^(-6)eV" min="0.0" decimal="5" max="10000.0">0.1</TolEnergy>
        </Broyden_param>
        <output_eigenvalue options="on,off" descriptions="on/off">off</output_eigenvalue>
        <Fvdw><tip_shape options="pyramidal,parabolic,spherical,conical">conical</tip_shape>
            <height_of_highest_adsorbed_molecule unit="Ang" decimal="5">0.00000</height_of_highest_adsorbed_molecule>
            <Hamaker_const unit="aJ/mol" min="0.0" decimal="5" max="10000.0">0.22000</Hamaker_const>
            <apex_angle unit="degree" min="0.0" decimal="5" max="10000.0">120.000</apex_angle>
            <tip_height unit="Ang" min="0.0" decimal="5" max="100000.0">1000.00</tip_height>
            <radius_of_tip_apex unit="Ang" min="0.0" decimal="5" max="10000.0">1.00000</radius_of_tip_apex>
        </Fvdw>
        <tip_bias_voltage><minimum unit="V" decimal="5">-1.0</minimum>
            <maximum unit="V" decimal="5">1.0</maximum>
            <Ndiv type="int" min="0">0</Ndiv>
        </tip_bias_voltage>
        <Ndiv_kpoints stepsize="2" type="int" min="2">4</Ndiv_kpoints>
        <electron_temperature unit="K" min="0.0" decimal="5" max="1000.0">50</electron_temperature>
        <tip_charge_neutrality><minimum unit="|e|" decimal="5">-0.1</minimum>
            <maximum unit="|e|" decimal="5">0.10000</maximum>
            <Ndiv type="int" min="0">4</Ndiv>
        </tip_charge_neutrality>
        <translational_vector><a><X unit="Ang" decimal="5">15.35014</X>
                <Y unit="Ang" decimal="5">0</Y>
                <Z unit="Ang" decimal="5">0</Z>
            </a>
            <b><X unit="Ang" decimal="5">0</X>
                <Y unit="Ang" decimal="5">15.35014</Y>
                <Z unit="Ang" decimal="5">0</Z>
            </b>
            <c><X unit="Ang" decimal="5">0</X>
                <Y unit="Ang" decimal="5">0</Y>
                <Z unit="Ang" decimal="5">100.00000</Z>
            </c>
        </translational_vector>
        <Output><Directory ctrl="label">.\<AtomPosition displaytype="movie" ctrl="label">atpos.mvf</AtomPosition>
                <Force_x displaytype="3D" ctrl="label">force_x.csv</Force_x>
                <Force_y displaytype="3D" ctrl="label">force_y.csv</Force_y>
                <Force_z displaytype="3D" ctrl="label">force_z.csv</Force_z>
                <Freq_shift displaytype="2D" ctrl="label">freq_shift.csv</Freq_shift>
                <EnergyLevel displaytype="text" ctrl="label">ene_lev.txt</EnergyLevel>
                <TunnelingCurrent displaytype="2D" ctrl="label">current.csv</TunnelingCurrent>
                <TunnelingSpectroscopy displaytype="1D" ctrl="label">current_spectro.csv</TunnelingSpectroscopy>
                <CurrentVoltage displaytype="1D" ctrl="label">curr_volt.csv</CurrentVoltage>
                <ContactPotential displaytype="2D" ctrl="label">LCPD.csv</ContactPotential>
            </Directory>
        </Output>
    </DFTB>
</Project>
